/*
 * Decompiled with CFR 0.152.
 */
package me.coley.illegalrenamer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import me.coley.recaf.graph.inheritance.HierarchyVertex;
import me.coley.recaf.mapping.Mappings;
import me.coley.recaf.util.ClassUtil;
import me.coley.recaf.util.Log;
import me.coley.recaf.workspace.Workspace;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class WorkspaceClassPatcher
implements Consumer<Workspace> {
    private static final int[] ALLOWED_TYPES = new int[]{1, 2, 9, 26};
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("_", "abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "Iterable", "long", "native", "new", "null", "Object", "package", "private", "protected", "public", "return", "RuntimeException", "short", "static", "static final", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "undefined", "var", "void", "volatile", "while"));
    private final Map<String, String> mappings = new HashMap<String, String>();
    private boolean keepPackages;
    private Workspace workspace;
    private int renameClassId = 1;
    private int renameFieldId = 1;
    private int renameMethodId = 1;

    public WorkspaceClassPatcher(boolean keepPackages) {
        this.keepPackages = keepPackages;
    }

    @Override
    public void accept(Workspace workspace) {
        this.workspace = workspace;
        this.renameClassId = 1;
        this.renameFieldId = 1;
        this.renameMethodId = 1;
        this.mappings.clear();
        this.renameInWorkspace(workspace);
    }

    private void renameInWorkspace(Workspace workspace) {
        for (String name : new TreeSet(workspace.getPrimaryClassNames())) {
            this.renameClass(workspace.getClassReader(name));
        }
        for (String name : new TreeSet(workspace.getPrimaryClassNames())) {
            this.renameMembers(workspace.getClassReader(name));
        }
        Log.info((String)"Detected {} illegal names", (Object[])new Object[]{this.mappings.size()});
        this.mappings.forEach((k, v) -> Log.info((String)"{}  ====> {}", (Object[])new Object[]{k, v}));
        Mappings mapper = new Mappings(workspace);
        mapper.setMappings(this.mappings);
        mapper.setCheckMethodHierarchy(true);
        mapper.setCheckFieldHierarchy(true);
        mapper.accept(workspace.getPrimary());
    }

    private void renameClass(ClassReader cr) {
        String outer;
        ClassReader outerReader;
        if (this.mappings.containsKey(cr.getClassName())) {
            return;
        }
        ClassNode cn = ClassUtil.getNode((ClassReader)cr, (int)0);
        if (cn.superName != null && this.workspace.getPrimaryClassNames().contains(cn.superName)) {
            this.renameClass(this.workspace.getClassReader(cn.superName));
        }
        for (String it : cn.interfaces) {
            if (!this.workspace.getPrimaryClassNames().contains(it)) continue;
            this.renameClass(this.workspace.getClassReader(it));
        }
        if (cn.outerClass != null && !cn.outerClass.equals(cr.getClassName()) && this.workspace.getPrimaryClassNames().contains(cn.outerClass)) {
            this.renameClass(this.workspace.getClassReader(cn.outerClass));
        } else if (cn.name.contains("$") && (outerReader = this.workspace.getClassReader(outer = cn.name.substring(0, cn.name.lastIndexOf("$")))) != null) {
            this.renameClass(outerReader);
        }
        if (this.isClassNameIllegal(cn.name)) {
            this.mappings.put(cn.name, this.generateClassName(this.renameClassId++, cn));
        }
    }

    private void renameMembers(ClassReader cr) {
        ClassNode cn = ClassUtil.getNode((ClassReader)cr, (int)0);
        for (FieldNode field : cn.fields) {
            if (!this.isMemberNameIllegal(field.name)) continue;
            this.mappings.put(cn.name + "." + field.name + " " + field.desc, this.generateFieldName(this.renameFieldId++, Type.getType((String)field.desc)));
        }
        for (MethodNode method : cn.methods) {
            if (this.isMemberNameIllegal(method.name)) {
                this.mappings.put(cn.name + "." + method.name + method.desc, this.generateMethodName(this.renameMethodId++, cn.name, method.name, Type.getType((String)method.desc)));
            }
            for (String exception : method.exceptions) {
                if (!this.isClassNameIllegal(exception)) continue;
                this.mappings.put(exception, this.generateClassName(this.renameClassId++, "java/lang/Exception", null, null));
            }
            for (String exception : method.tryCatchBlocks) {
                if (((TryCatchBlockNode)exception).type == null || !this.isClassNameIllegal(((TryCatchBlockNode)exception).type)) continue;
                this.mappings.put(((TryCatchBlockNode)exception).type, this.generateClassName(this.renameClassId++, "java/lang/Exception", null, null));
            }
            if (method.instructions == null) continue;
            for (AbstractInsnNode insn : method.instructions) {
                if (insn.getOpcode() != 186) continue;
                InvokeDynamicInsnNode indy = (InvokeDynamicInsnNode)insn;
                String indyKey = "." + indy.name + indy.desc;
                if (this.mappings.containsKey(indyKey) || !this.isMemberNameIllegal(indy.name)) continue;
                this.mappings.put(indyKey, this.generateDynamicMethodName(this.renameMethodId++, Type.getType((String)method.desc)));
            }
        }
    }

    private String generateClassName(int index, ClassNode cn) {
        return this.generateClassName(index, cn.name, cn.superName, cn.interfaces);
    }

    private String generateClassName(int index, String name, String superName, Collection<String> interfaces) {
        String packageName;
        String prefix = "";
        int slash = name.lastIndexOf(47);
        String simpleName = name.substring(slash + 1);
        if (this.keepPackages && this.isClassNameIllegal(simpleName) && slash > 0 && !this.isClassNameIllegal((packageName = name.substring(0, slash)) + "/Test")) {
            prefix = packageName + '/';
        }
        if (simpleName.contains("$")) {
            String outer = name.substring(0, name.lastIndexOf("$"));
            if (this.isClassNameIllegal(outer)) {
                String outerMapped = this.mappings.get(outer);
                if (outerMapped == null) {
                    throw new IllegalStateException("Outer class was not mapped: " + outer);
                }
                prefix = outerMapped + "$";
            } else {
                prefix = outer + "$";
            }
        }
        String typeHint = null;
        if (interfaces != null && (superName == null || superName.equals("java/lang/Object"))) {
            for (String i : interfaces) {
                if (this.isClassNameIllegal(i)) continue;
                typeHint = i.substring(i.lastIndexOf(47) + 1);
            }
        } else if (superName != null && !this.isClassNameIllegal(superName)) {
            typeHint = superName.substring(superName.lastIndexOf(47) + 1);
        }
        if (typeHint == null) {
            return prefix + "Class" + index;
        }
        return prefix + "Class" + index + "_" + typeHint;
    }

    private String generateFieldName(int index, Type type) {
        int sort = type.getSort();
        String typeHint = type.getInternalName();
        typeHint = this.mappings.getOrDefault(typeHint, typeHint);
        if ((typeHint = typeHint.substring(typeHint.lastIndexOf(47) + 1)).contains("$")) {
            typeHint = typeHint.substring(typeHint.lastIndexOf(36) + 1);
        }
        if (sort <= 8) {
            String typeStr = type.getClassName();
            return "fd_" + typeStr + "_" + index;
        }
        if (sort == 9) {
            return "fd_array_" + index;
        }
        return "fd_" + typeHint + "_" + index;
    }

    private String generateMethodName(int index, String owner, String name, Type type) {
        int sort;
        Set entries = this.workspace.getHierarchyGraph().getHierarchy(owner);
        for (HierarchyVertex vert : entries) {
            String existing = this.mappings.get(vert.getClassName() + "." + name + type.getDescriptor());
            if (existing == null) continue;
            return existing;
        }
        Type retType = type.getReturnType();
        String typeHint = retType.getInternalName();
        if (retType.getSort() == 10) {
            typeHint = this.mappings.getOrDefault(typeHint, typeHint);
            if ((typeHint = typeHint.substring(typeHint.lastIndexOf(47) + 1)).contains("$")) {
                typeHint = typeHint.substring(typeHint.lastIndexOf(36) + 1);
            }
        } else {
            typeHint = retType.getClassName();
        }
        if ((sort = retType.getSort()) <= 8) {
            String typeStr = retType.getClassName();
            return "md_" + typeStr + "_" + index;
        }
        if (sort == 9) {
            return "md_array_" + index;
        }
        return "md_" + typeHint + "_" + index;
    }

    private String generateDynamicMethodName(int index, Type type) {
        Type retType = type.getReturnType();
        int sort = retType.getSort();
        if (sort <= 8) {
            String typeStr = retType.getClassName();
            return "dyn_" + typeStr + "_" + index;
        }
        if (sort == 9) {
            return "dyn_array_" + index;
        }
        return "dyn_" + index;
    }

    private boolean isClassNameIllegal(String name) {
        String selfInnerName;
        if (name.endsWith("package-info") || name.endsWith("module-info")) {
            return false;
        }
        String simpleName = name.substring(name.lastIndexOf(47) + 1);
        if (simpleName.contains("$") && KEYWORDS.contains(selfInnerName = simpleName.substring(simpleName.lastIndexOf("$") + 1))) {
            return true;
        }
        if (KEYWORDS.contains(simpleName)) {
            return true;
        }
        if (simpleName.matches("\\d+")) {
            return true;
        }
        for (char ch : name.toCharArray()) {
            if (ch == '/' || ch == '$' || ch == '_' || Arrays.binarySearch(ALLOWED_TYPES, Character.getType(ch)) >= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberNameIllegal(String name) {
        if ("<clinit>".equals(name) || "<init>".equals(name)) {
            return false;
        }
        if (KEYWORDS.contains(name)) {
            return true;
        }
        for (char ch : name.toCharArray()) {
            if (ch == '$' || ch == '_' || Arrays.binarySearch(ALLOWED_TYPES, Character.getType(ch)) >= 0) continue;
            return true;
        }
        return false;
    }
}

