/*
 * Decompiled with CFR 0.152.
 */
package me.coley.strrep;

import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class StringReplaceVisitor
extends ClassVisitor {
    private final String input;
    private final String replacement;
    private boolean dirty;

    public StringReplaceVisitor(ClassWriter cw, String input, String replacement) {
        super(524288, (ClassVisitor)cw);
        this.input = input;
        this.replacement = replacement;
        if (replacement.contains(input)) {
            throw new IllegalArgumentException("Replacement contains input pattern");
        }
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (value instanceof String) {
            value = this.patch((String)value);
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return new StringReplaceMethodVisitor(super.visitMethod(access, name, descriptor, signature, exceptions));
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private String patch(String value) {
        if (value.contains(this.input)) {
            value = value.replace(this.input, this.replacement);
            this.dirty = true;
        }
        return value;
    }

    private class StringReplaceMethodVisitor
    extends MethodVisitor {
        public StringReplaceMethodVisitor(MethodVisitor mv) {
            super(524288, mv);
        }

        public void visitLdcInsn(Object value) {
            if (value instanceof String) {
                value = StringReplaceVisitor.this.patch((String)value);
            }
            super.visitLdcInsn(value);
        }
    }
}

