/*
 * Decompiled with CFR 0.152.
 */
package me.coley.strrep;

import java.util.HashSet;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import me.coley.recaf.control.Controller;
import me.coley.recaf.control.gui.GuiController;
import me.coley.recaf.plugin.api.MenuProviderPlugin;
import me.coley.recaf.plugin.api.StartupPlugin;
import me.coley.recaf.ui.controls.ActionButton;
import me.coley.recaf.ui.controls.ActionMenuItem;
import me.coley.recaf.ui.controls.view.ClassViewport;
import me.coley.recaf.workspace.WorkspaceClassWriter;
import me.coley.strrep.StringReplaceVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.plugface.core.annotations.Plugin;

@Plugin(name="String Replace")
public class StringReplacerPlugin
implements MenuProviderPlugin,
StartupPlugin {
    private Controller controller;

    public String getVersion() {
        return "1.0.0";
    }

    public String getDescription() {
        return "String replacer";
    }

    public Menu createMenu() {
        Menu menu = new Menu(this.getName());
        menu.getItems().addAll((Object[])new MenuItem[]{new ActionMenuItem("Replace exact", () -> {
            GuiController gController = (GuiController)this.controller;
            gController.windows().window(this.getName(), this.createReplacePanel(gController)).show();
        })});
        return menu;
    }

    public void onStart(Controller controller) {
        this.controller = controller;
    }

    private Parent createReplacePanel(GuiController gController) {
        TextField txtInput = new TextField();
        TextField txtReplace = new TextField();
        GridPane grid = new GridPane();
        grid.addRow(0, new Node[]{new Label("Find text:"), txtInput});
        grid.addRow(1, new Node[]{new Label("Replace with:"), txtReplace});
        grid.addRow(2, new Node[]{new ActionButton("Replace all", () -> {
            String pattern = txtInput.getText();
            for (ClassReader cr : new HashSet(this.controller.getWorkspace().getPrimaryClassReaders())) {
                WorkspaceClassWriter cw = this.controller.getWorkspace().createWriter(2);
                StringReplaceVisitor rep = new StringReplaceVisitor((ClassWriter)cw, txtInput.getText(), txtReplace.getText());
                cr.accept((ClassVisitor)rep, 0);
                if (!rep.isDirty()) continue;
                this.controller.getWorkspace().getPrimary().getClasses().put((Object)cr.getClassName(), (Object)cw.toByteArray());
                ClassViewport view = gController.windows().getMainWindow().getClassViewport(cr.getClassName());
                if (view == null) continue;
                view.updateView();
            }
        })});
        return grid;
    }
}

